#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_python.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
#
from __future__ import absolute_import, division, print_function, unicode_literals

from h2o.estimators.estimator_base import H2OEstimator
from h2o.exceptions import H2OValueError
from h2o.frame import H2OFrame
from h2o.utils.typechecks import assert_is_type, Enum, numeric


class H2OXGBoostEstimator(H2OEstimator):
    """
    XGBoost

    Builds a eXtreme Gradient Boosting model using the native XGBoost backend.
    """

    algo = "xgboost"

    def __init__(self, **kwargs):
        super(H2OXGBoostEstimator, self).__init__()
        self._parms = {}
        names_list = {"model_id", "training_frame", "validation_frame", "nfolds", "keep_cross_validation_predictions",
                      "keep_cross_validation_fold_assignment", "score_each_iteration", "fold_assignment", "fold_column",
                      "response_column", "ignored_columns", "ignore_const_cols", "offset_column", "weights_column",
                      "stopping_rounds", "stopping_metric", "stopping_tolerance", "max_runtime_secs", "seed",
                      "distribution", "tweedie_power", "ntrees", "max_depth", "min_rows", "learn_rate", "sample_rate",
                      "col_sample_rate", "col_sample_rate_per_tree", "max_abs_leafnode_pred", "score_tree_interval",
                      "min_split_improvement", "max_bin", "num_leaves", "min_sum_hessian_in_leaf", "min_data_in_leaf",
                      "tree_method", "grow_policy", "booster", "lambda_", "alpha"}
        if "Lambda" in kwargs: kwargs["lambda_"] = kwargs.pop("Lambda")
        for pname, pvalue in kwargs.items():
            if pname == 'model_id':
                self._id = pvalue
                self._parms["model_id"] = pvalue
            elif pname in names_list:
                # Using setattr(...) will invoke type-checking of the arguments
                setattr(self, pname, pvalue)
            else:
                raise H2OValueError("Unknown parameter %s = %r" % (pname, pvalue))

    @property
    def training_frame(self):
        """str: Id of the training data frame (Not required, to allow initial validation of model parameters)."""
        return self._parms.get("training_frame")

    @training_frame.setter
    def training_frame(self, training_frame):
        assert_is_type(training_frame, None, H2OFrame)
        self._parms["training_frame"] = training_frame


    @property
    def validation_frame(self):
        """str: Id of the validation data frame."""
        return self._parms.get("validation_frame")

    @validation_frame.setter
    def validation_frame(self, validation_frame):
        assert_is_type(validation_frame, None, H2OFrame)
        self._parms["validation_frame"] = validation_frame


    @property
    def nfolds(self):
        """int: Number of folds for N-fold cross-validation (0 to disable or >= 2). (Default: 0)"""
        return self._parms.get("nfolds")

    @nfolds.setter
    def nfolds(self, nfolds):
        assert_is_type(nfolds, None, int)
        self._parms["nfolds"] = nfolds


    @property
    def keep_cross_validation_predictions(self):
        """bool: Whether to keep the predictions of the cross-validation models. (Default: False)"""
        return self._parms.get("keep_cross_validation_predictions")

    @keep_cross_validation_predictions.setter
    def keep_cross_validation_predictions(self, keep_cross_validation_predictions):
        assert_is_type(keep_cross_validation_predictions, None, bool)
        self._parms["keep_cross_validation_predictions"] = keep_cross_validation_predictions


    @property
    def keep_cross_validation_fold_assignment(self):
        """bool: Whether to keep the cross-validation fold assignment. (Default: False)"""
        return self._parms.get("keep_cross_validation_fold_assignment")

    @keep_cross_validation_fold_assignment.setter
    def keep_cross_validation_fold_assignment(self, keep_cross_validation_fold_assignment):
        assert_is_type(keep_cross_validation_fold_assignment, None, bool)
        self._parms["keep_cross_validation_fold_assignment"] = keep_cross_validation_fold_assignment


    @property
    def score_each_iteration(self):
        """bool: Whether to score during each iteration of model training. (Default: False)"""
        return self._parms.get("score_each_iteration")

    @score_each_iteration.setter
    def score_each_iteration(self, score_each_iteration):
        assert_is_type(score_each_iteration, None, bool)
        self._parms["score_each_iteration"] = score_each_iteration


    @property
    def fold_assignment(self):
        """
        Enum["auto", "random", "modulo", "stratified"]: Cross-validation fold assignment scheme, if fold_column is not
        specified. The 'Stratified' option will stratify the folds based on the response variable, for classification
        problems. (Default: "auto")
        """
        return self._parms.get("fold_assignment")

    @fold_assignment.setter
    def fold_assignment(self, fold_assignment):
        assert_is_type(fold_assignment, None, Enum("auto", "random", "modulo", "stratified"))
        self._parms["fold_assignment"] = fold_assignment


    @property
    def fold_column(self):
        """str: Column with cross-validation fold index assignment per observation."""
        return self._parms.get("fold_column")

    @fold_column.setter
    def fold_column(self, fold_column):
        assert_is_type(fold_column, None, str)
        self._parms["fold_column"] = fold_column


    @property
    def response_column(self):
        """str: Response variable column."""
        return self._parms.get("response_column")

    @response_column.setter
    def response_column(self, response_column):
        assert_is_type(response_column, None, str)
        self._parms["response_column"] = response_column


    @property
    def ignored_columns(self):
        """List[str]: Names of columns to ignore for training."""
        return self._parms.get("ignored_columns")

    @ignored_columns.setter
    def ignored_columns(self, ignored_columns):
        assert_is_type(ignored_columns, None, [str])
        self._parms["ignored_columns"] = ignored_columns


    @property
    def ignore_const_cols(self):
        """bool: Ignore constant columns. (Default: True)"""
        return self._parms.get("ignore_const_cols")

    @ignore_const_cols.setter
    def ignore_const_cols(self, ignore_const_cols):
        assert_is_type(ignore_const_cols, None, bool)
        self._parms["ignore_const_cols"] = ignore_const_cols


    @property
    def offset_column(self):
        """
        str: Offset column. This will be added to the combination of columns before applying the link function.
        """
        return self._parms.get("offset_column")

    @offset_column.setter
    def offset_column(self, offset_column):
        assert_is_type(offset_column, None, str)
        self._parms["offset_column"] = offset_column


    @property
    def weights_column(self):
        """
        str: Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it
        from the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice.
        Negative weights are not allowed.
        """
        return self._parms.get("weights_column")

    @weights_column.setter
    def weights_column(self, weights_column):
        assert_is_type(weights_column, None, str)
        self._parms["weights_column"] = weights_column


    @property
    def stopping_rounds(self):
        """
        int: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) (Default: 0)
        """
        return self._parms.get("stopping_rounds")

    @stopping_rounds.setter
    def stopping_rounds(self, stopping_rounds):
        assert_is_type(stopping_rounds, None, int)
        self._parms["stopping_rounds"] = stopping_rounds


    @property
    def stopping_metric(self):
        """
        Enum["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "lift_top_group", "misclassification",
        "mean_per_class_error"]: Metric to use for early stopping (AUTO: logloss for classification, deviance for
        regression) (Default: "auto")
        """
        return self._parms.get("stopping_metric")

    @stopping_metric.setter
    def stopping_metric(self, stopping_metric):
        assert_is_type(stopping_metric, None, Enum("auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "lift_top_group", "misclassification", "mean_per_class_error"))
        self._parms["stopping_metric"] = stopping_metric


    @property
    def stopping_tolerance(self):
        """
        float: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
        much) (Default: 0.001)
        """
        return self._parms.get("stopping_tolerance")

    @stopping_tolerance.setter
    def stopping_tolerance(self, stopping_tolerance):
        assert_is_type(stopping_tolerance, None, numeric)
        self._parms["stopping_tolerance"] = stopping_tolerance


    @property
    def max_runtime_secs(self):
        """float: Maximum allowed runtime in seconds for model training. Use 0 to disable. (Default: 0)"""
        return self._parms.get("max_runtime_secs")

    @max_runtime_secs.setter
    def max_runtime_secs(self, max_runtime_secs):
        assert_is_type(max_runtime_secs, None, numeric)
        self._parms["max_runtime_secs"] = max_runtime_secs


    @property
    def seed(self):
        """int: Seed for pseudo random number generator (if applicable) (Default: -1)"""
        return self._parms.get("seed")

    @seed.setter
    def seed(self, seed):
        assert_is_type(seed, None, int)
        self._parms["seed"] = seed


    @property
    def distribution(self):
        """
        Enum["auto", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile",
        "huber"]: Distribution function (Default: "auto")
        """
        return self._parms.get("distribution")

    @distribution.setter
    def distribution(self, distribution):
        assert_is_type(distribution, None, Enum("auto", "bernoulli", "multinomial", "gaussian", "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"))
        self._parms["distribution"] = distribution


    @property
    def tweedie_power(self):
        """float: Tweedie power for Tweedie regression, must be between 1 and 2. (Default: 1.5)"""
        return self._parms.get("tweedie_power")

    @tweedie_power.setter
    def tweedie_power(self, tweedie_power):
        assert_is_type(tweedie_power, None, numeric)
        self._parms["tweedie_power"] = tweedie_power


    @property
    def ntrees(self):
        """int: Number of trees. (Default: 50)"""
        return self._parms.get("ntrees")

    @ntrees.setter
    def ntrees(self, ntrees):
        assert_is_type(ntrees, None, int)
        self._parms["ntrees"] = ntrees


    @property
    def max_depth(self):
        """int: Maximum tree depth. (Default: 5)"""
        return self._parms.get("max_depth")

    @max_depth.setter
    def max_depth(self, max_depth):
        assert_is_type(max_depth, None, int)
        self._parms["max_depth"] = max_depth


    @property
    def min_rows(self):
        """float: Fewest allowed (weighted) observations in a leaf. (Default: 10)"""
        return self._parms.get("min_rows")

    @min_rows.setter
    def min_rows(self, min_rows):
        assert_is_type(min_rows, None, numeric)
        self._parms["min_rows"] = min_rows


    @property
    def learn_rate(self):
        """float: Learning rate (from 0.0 to 1.0) (Default: 0.1)"""
        return self._parms.get("learn_rate")

    @learn_rate.setter
    def learn_rate(self, learn_rate):
        assert_is_type(learn_rate, None, numeric)
        self._parms["learn_rate"] = learn_rate


    @property
    def sample_rate(self):
        """float: Row sample rate per tree (from 0.0 to 1.0) (Default: 1)"""
        return self._parms.get("sample_rate")

    @sample_rate.setter
    def sample_rate(self, sample_rate):
        assert_is_type(sample_rate, None, numeric)
        self._parms["sample_rate"] = sample_rate


    @property
    def col_sample_rate(self):
        """float: Column sample rate (from 0.0 to 1.0) (Default: 1)"""
        return self._parms.get("col_sample_rate")

    @col_sample_rate.setter
    def col_sample_rate(self, col_sample_rate):
        assert_is_type(col_sample_rate, None, numeric)
        self._parms["col_sample_rate"] = col_sample_rate


    @property
    def col_sample_rate_per_tree(self):
        """float: Column sample rate per tree (from 0.0 to 1.0) (Default: 1)"""
        return self._parms.get("col_sample_rate_per_tree")

    @col_sample_rate_per_tree.setter
    def col_sample_rate_per_tree(self, col_sample_rate_per_tree):
        assert_is_type(col_sample_rate_per_tree, None, numeric)
        self._parms["col_sample_rate_per_tree"] = col_sample_rate_per_tree


    @property
    def max_abs_leafnode_pred(self):
        """float: Maximum absolute value of a leaf node prediction (Default: 3.4028235e+38)"""
        return self._parms.get("max_abs_leafnode_pred")

    @max_abs_leafnode_pred.setter
    def max_abs_leafnode_pred(self, max_abs_leafnode_pred):
        assert_is_type(max_abs_leafnode_pred, None, float)
        self._parms["max_abs_leafnode_pred"] = max_abs_leafnode_pred


    @property
    def score_tree_interval(self):
        """int: Score the model after every so many trees. Disabled if set to 0. (Default: 0)"""
        return self._parms.get("score_tree_interval")

    @score_tree_interval.setter
    def score_tree_interval(self, score_tree_interval):
        assert_is_type(score_tree_interval, None, int)
        self._parms["score_tree_interval"] = score_tree_interval


    @property
    def min_split_improvement(self):
        """float: Minimum relative improvement in squared error reduction for a split to happen (Default: 0)"""
        return self._parms.get("min_split_improvement")

    @min_split_improvement.setter
    def min_split_improvement(self, min_split_improvement):
        assert_is_type(min_split_improvement, None, float)
        self._parms["min_split_improvement"] = min_split_improvement


    @property
    def max_bin(self):
        """int: For tree_method=hist only: maximum number of bins (Default: 255)"""
        return self._parms.get("max_bin")

    @max_bin.setter
    def max_bin(self, max_bin):
        assert_is_type(max_bin, None, int)
        self._parms["max_bin"] = max_bin


    @property
    def num_leaves(self):
        """int: For tree_method=hist only: maximum number of leaves (Default: 255)"""
        return self._parms.get("num_leaves")

    @num_leaves.setter
    def num_leaves(self, num_leaves):
        assert_is_type(num_leaves, None, int)
        self._parms["num_leaves"] = num_leaves


    @property
    def min_sum_hessian_in_leaf(self):
        """
        float: For tree_method=hist only: the mininum sum of hessian in a leaf to keep splitting (Default: 100)
        """
        return self._parms.get("min_sum_hessian_in_leaf")

    @min_sum_hessian_in_leaf.setter
    def min_sum_hessian_in_leaf(self, min_sum_hessian_in_leaf):
        assert_is_type(min_sum_hessian_in_leaf, None, float)
        self._parms["min_sum_hessian_in_leaf"] = min_sum_hessian_in_leaf


    @property
    def min_data_in_leaf(self):
        """float: For tree_method=hist only: the mininum data in a leaf to keep splitting (Default: 0)"""
        return self._parms.get("min_data_in_leaf")

    @min_data_in_leaf.setter
    def min_data_in_leaf(self, min_data_in_leaf):
        assert_is_type(min_data_in_leaf, None, float)
        self._parms["min_data_in_leaf"] = min_data_in_leaf


    @property
    def tree_method(self):
        """Enum["auto", "exact", "approx", "hist"]: Tree method (Default: "auto")"""
        return self._parms.get("tree_method")

    @tree_method.setter
    def tree_method(self, tree_method):
        assert_is_type(tree_method, None, Enum("auto", "exact", "approx", "hist"))
        self._parms["tree_method"] = tree_method


    @property
    def grow_policy(self):
        """
        Enum["depthwise", "lossguide"]: Grow policy - depthwise is standard GBM, lossguide is LightGBM (Default:
        "depthwise")
        """
        return self._parms.get("grow_policy")

    @grow_policy.setter
    def grow_policy(self, grow_policy):
        assert_is_type(grow_policy, None, Enum("depthwise", "lossguide"))
        self._parms["grow_policy"] = grow_policy


    @property
    def booster(self):
        """Enum["gbtree", "gblinear"]: Booster type (Default: "gbtree")"""
        return self._parms.get("booster")

    @booster.setter
    def booster(self, booster):
        assert_is_type(booster, None, Enum("gbtree", "gblinear"))
        self._parms["booster"] = booster


    @property
    def lambda_(self):
        """float: L2 regularization (Default: 1)"""
        return self._parms.get("lambda")

    @lambda_.setter
    def lambda_(self, lambda_):
        assert_is_type(lambda_, None, float)
        self._parms["lambda"] = lambda_


    @property
    def alpha(self):
        """float: L1 regularization (Default: 0)"""
        return self._parms.get("alpha")

    @alpha.setter
    def alpha(self, alpha):
        assert_is_type(alpha, None, float)
        self._parms["alpha"] = alpha



    # Ask the H2O server whether a XGBoost model can be built (depends on availability of native backends)
    @staticmethod
    def available():
        """
        Returns True if a XGBoost model can be built, or False otherwise.
        """
        builder_json = h2o.api("GET /3/ModelBuilders", data={"algo": "xgboost"})
        visibility = builder_json["model_builders"]["xgboost"]["visibility"]
        if (visibility == "Experimental"):
            print("Cannot build an XGBoost model - no backend found.")
            return False
        else:
            return True
