/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String nativePath = "../lib/";
    private static final String nativeResourcePath = "/lib/";
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    public static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            for (String libName : libNames) {
                NativeLibLoader.smartLoad(libName);
            }
            initialized = true;
        }
    }

    private static void loadLibraryFromJar(String path2) throws IOException, IllegalArgumentException {
        String temp = NativeLibLoader.createTempFileFromResource(path2);
        System.load(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createTempFileFromResource(String path2) throws IOException, IllegalArgumentException {
        if (!path2.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path2.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string2 = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeLibLoader.class.getResourceAsStream(path2);
        if (is == null) {
            throw new FileNotFoundException("File " + path2 + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        return temp.getAbsolutePath();
    }

    private static void smartLoad(String libName) throws IOException {
        NativeLibLoader.addNativeDir(nativePath);
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                String libraryFromJar = nativeResourcePath + System.mapLibraryName(libName);
                NativeLibLoader.loadLibraryFromJar(libraryFromJar);
            }
            catch (IOException ioe) {
                logger.error("failed to load library from both native path and jar");
                throw ioe;
            }
        }
    }

    private static void addNativeDir(String libPath) throws IOException {
        try {
            String[] paths;
            Field field2 = ClassLoader.class.getDeclaredField("usr_paths");
            field2.setAccessible(true);
            for (String path2 : paths = (String[])field2.get(null)) {
                if (!libPath.equals(path2)) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = libPath;
            field2.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            logger.error(e.getMessage());
            throw new IOException("Failed to get field handle to set library path");
        }
    }
}

