/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

abstract class ConfigNumber
extends AbstractConfigValue
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected final String originalText;

    protected ConfigNumber(ConfigOrigin origin2, String originalText) {
        super(origin2);
        this.originalText = originalText;
    }

    @Override
    public abstract Number unwrapped();

    @Override
    String transformToString() {
        return this.originalText;
    }

    int intValueRangeChecked(String path2) {
        long l = this.longValue();
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ConfigException.WrongType(this.origin(), path2, "32-bit integer", "out-of-range value " + l);
        }
        return (int)l;
    }

    protected abstract long longValue();

    protected abstract double doubleValue();

    private boolean isWhole() {
        long asLong = this.longValue();
        return (double)asLong == this.doubleValue();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigNumber;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigNumber && this.canEqual(other)) {
            ConfigNumber n = (ConfigNumber)other;
            if (this.isWhole()) {
                return n.isWhole() && this.longValue() == n.longValue();
            }
            return !n.isWhole() && this.doubleValue() == n.doubleValue();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long asLong = this.isWhole() ? this.longValue() : Double.doubleToLongBits(this.doubleValue());
        return (int)(asLong ^ asLong >>> 32);
    }

    static ConfigNumber newNumber(ConfigOrigin origin2, long number2, String originalText) {
        if (number2 <= Integer.MAX_VALUE && number2 >= Integer.MIN_VALUE) {
            return new ConfigInt(origin2, (int)number2, originalText);
        }
        return new ConfigLong(origin2, number2, originalText);
    }

    static ConfigNumber newNumber(ConfigOrigin origin2, double number2, String originalText) {
        long asLong = (long)number2;
        if ((double)asLong == number2) {
            return ConfigNumber.newNumber(origin2, asLong, originalText);
        }
        return new ConfigDouble(origin2, number2, originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

