/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;

public class DefaultSerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map2) {
            TreeMap treeMap = (TreeMap)map2;
            boolean references = kryo.setReferences(false);
            kryo.writeClassAndObject(output, treeMap.comparator());
            kryo.setReferences(references);
            super.write(kryo, output, map2);
        }

        @Override
        protected Map create(Kryo kryo, Input input2, Class<Map> type) {
            return new TreeMap((Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map original) {
            return new TreeMap(((TreeMap)original).comparator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar object) {
            this.timeZoneSerializer.write(kryo, output, object.getTimeZone());
            output.writeLong(object.getTimeInMillis(), true);
            output.writeBoolean(object.isLenient());
            output.writeInt(object.getFirstDayOfWeek(), true);
            output.writeInt(object.getMinimalDaysInFirstWeek(), true);
            if (object instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)object).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input2, Class<Calendar> type) {
            Calendar result2 = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input2, (Class)TimeZone.class));
            result2.setTimeInMillis(input2.readLong(true));
            result2.setLenient(input2.readBoolean());
            result2.setFirstDayOfWeek(input2.readInt(true));
            result2.setMinimalDaysInFirstWeek(input2.readInt(true));
            long gregorianChange = input2.readLong(false);
            if (gregorianChange != -12219292800000L && result2 instanceof GregorianCalendar) {
                ((GregorianCalendar)result2).setGregorianChange(new Date(gregorianChange));
            }
            return result2;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar original) {
            return (Calendar)original.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone object) {
            output.writeString(object.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input2, Class<TimeZone> type) {
            return TimeZone.getTimeZone(input2.readString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set object) {
            kryo.writeClassAndObject(output, object.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input2, Class type) {
            return Collections.singleton(kryo.readClassAndObject(input2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map object) {
            Map.Entry entry2 = object.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry2.getKey());
            kryo.writeClassAndObject(output, entry2.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input2, Class type) {
            Object key = kryo.readClassAndObject(input2);
            Object value2 = kryo.readClassAndObject(input2);
            return Collections.singletonMap(key, value2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List object) {
            kryo.writeClassAndObject(output, object.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input2, Class type) {
            return Collections.singletonList(kryo.readClassAndObject(input2));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable object) {
            object.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input2, Class<KryoSerializable> type) {
            KryoSerializable object = kryo.newInstance(type);
            kryo.reference(object);
            object.read(kryo, input2);
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder object) {
            output.writeString(object);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input2, Class<StringBuilder> type) {
            return input2.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder original) {
            return new StringBuilder(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer object) {
            output.writeString(object);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input2, Class<StringBuffer> type) {
            String value2 = input2.readString();
            if (value2 == null) {
                return null;
            }
            return new StringBuffer(value2);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer original) {
            return new StringBuffer(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency object) {
            output.writeString(object == null ? null : object.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input2, Class<Currency> type) {
            String currencyCode = input2.readString();
            if (currencyCode == null) {
                return null;
            }
            return Currency.getInstance(currencyCode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet object) {
            if (object.isEmpty()) {
                throw new KryoException("An empty EnumSet cannot be serialized.");
            }
            Serializer serializer = kryo.writeClass(output, object.iterator().next().getClass()).getSerializer();
            output.writeInt(object.size(), true);
            for (Object element : object) {
                serializer.write(kryo, output, element);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input2, Class<EnumSet> type) {
            Registration registration = kryo.readClass(input2);
            EnumSet object = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int length = input2.readInt(true);
            for (int i = 0; i < length; ++i) {
                object.add(serializer.read(kryo, input2, null));
            }
            return object;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet original) {
            return EnumSet.copyOf(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> type) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = type.getEnumConstants();
            if (this.enumConstants == null) {
                throw new IllegalArgumentException("The type must be an enum: " + type);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeInt(object.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input2, Class<Enum> type) {
            int ordinal = input2.readInt(true);
            if (ordinal == 0) {
                return null;
            }
            if (--ordinal < 0 || ordinal > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
            }
            Object constant = this.enumConstants[ordinal];
            return (Enum)constant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    extends Serializer<Date> {
        @Override
        public void write(Kryo kryo, Output output, Date object) {
            output.writeLong(object.getTime(), true);
        }

        @Override
        public Date read(Kryo kryo, Input input2, Class<Date> type) {
            return new Date(input2.readLong(true));
        }

        @Override
        public Date copy(Kryo kryo, Date original) {
            return new Date(original.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class object) {
            kryo.writeClass(output, object);
        }

        @Override
        public Class read(Kryo kryo, Input input2, Class<Class> type) {
            return kryo.readClass(input2).getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            BigDecimal value2 = object;
            this.bigIntegerSerializer.write(kryo, output, value2.unscaledValue());
            output.writeInt(value2.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input2, Class<BigDecimal> type) {
            Object unscaledValue = this.bigIntegerSerializer.read(kryo, input2, (Class)null);
            if (unscaledValue == null) {
                return null;
            }
            int scale = input2.readInt(false);
            return new BigDecimal((BigInteger)unscaledValue, scale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            BigInteger value2 = object;
            byte[] bytes2 = value2.toByteArray();
            output.writeInt(bytes2.length + 1, true);
            output.writeBytes(bytes2);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input2, Class<BigInteger> type) {
            int length = input2.readInt(true);
            if (length == 0) {
                return null;
            }
            byte[] bytes2 = input2.readBytes(length - 1);
            return new BigInteger(bytes2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String object) {
            output.writeString(object);
        }

        @Override
        public String read(Kryo kryo, Input input2, Class<String> type) {
            return input2.readString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double object) {
            output.writeDouble(object);
        }

        @Override
        public Double read(Kryo kryo, Input input2, Class<Double> type) {
            return input2.readDouble();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float object) {
            output.writeFloat(object.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input2, Class<Float> type) {
            return Float.valueOf(input2.readFloat());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long object) {
            output.writeLong(object, false);
        }

        @Override
        public Long read(Kryo kryo, Input input2, Class<Long> type) {
            return input2.readLong(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer object) {
            output.writeInt(object, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input2, Class<Integer> type) {
            return input2.readInt(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short object) {
            output.writeShort(object.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input2, Class<Short> type) {
            return input2.readShort();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character object) {
            output.writeChar(object.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input2, Class<Character> type) {
            return Character.valueOf(input2.readChar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte object) {
            output.writeByte(object);
        }

        @Override
        public Byte read(Kryo kryo, Input input2, Class<Byte> type) {
            return input2.readByte();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean object) {
            output.writeBoolean(object);
        }

        @Override
        public Boolean read(Kryo kryo, Input input2, Class<Boolean> type) {
            return input2.readBoolean();
        }
    }
}

