/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInterruptedException;
import akka.actor.ActorRef;
import akka.actor.ActorRefScope;
import akka.actor.ChildRestartStats;
import akka.actor.InternalActorRef;
import akka.actor.PostRestartException;
import akka.actor.PreRestartException;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$Termination$;
import akka.actor.dungeon.FaultHandling$;
import akka.dispatch.Envelope$;
import akka.dispatch.sysmsg.DeathWatchNotification;
import akka.dispatch.sysmsg.Failed;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Error$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class FaultHandling$class {
    private static void suspendNonRecursive(ActorCell $this) {
        $this.dispatcher().suspend($this);
    }

    private static void resumeNonRecursive(ActorCell $this) {
        $this.dispatcher().resume($this);
    }

    private static boolean isFailed(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed() != null;
    }

    private static void setFailed(ActorCell $this, ActorRef perpetrator) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(perpetrator);
    }

    private static void clearFailed(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }

    private static ActorRef perpetrator(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void faultRecreate(ActorCell $this, Throwable cause) {
        BoxedUnit boxedUnit;
        if ($this.actor() == null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Recreate into Create after ").append(cause).toString()));
            $this.faultCreate();
            return;
        }
        if (!$this.isNormal()) {
            $this.faultResume(null);
            return;
        }
        Actor failedActor = $this.actor();
        if ($this.system().settings().DebugLifecycle()) {
            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(failedActor), "restarting"));
        }
        if (failedActor != null) {
            Option option = $this.currentMessage() != null ? new Some<Object>($this.currentMessage().message()) : None$.MODULE$;
            try {
                if (failedActor.context() != null) {
                    failedActor.aroundPreRestart(cause, option);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable2) {
                try {
                    PartialFunction<Throwable, BoxedUnit> catchExpr1 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable($this, failedActor, option, cause){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;
                        private final Actor failedActor$1;
                        private final Option optionalMessage$1;
                        private final Throwable cause$2;

                        public final void apply(Throwable e) {
                            PreRestartException ex = new PreRestartException(this.$outer.self(), e, this.cause$2, this.optionalMessage$1);
                            this.$outer.publish(new Logging.Error(ex, this.$outer.self().path().toString(), this.$outer.clazz(this.failedActor$1), e.getMessage()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.failedActor$1 = failedActor$1;
                            this.optionalMessage$1 = optionalMessage$1;
                            this.cause$2 = cause$2;
                        }
                    }));
                    if (!catchExpr1.isDefinedAt(throwable2)) throw throwable2;
                    boxedUnit = catchExpr1.apply(throwable2);
                }
                finally {
                    $this.clearActorFields(failedActor);
                }
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"mailbox must be suspended during restart, status=").append(BoxesRunTime.boxToInteger(this.$outer.mailbox().currentStatus())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        if ($this.setChildrenTerminationReason(new ChildrenContainer.Recreation(cause))) return;
        FaultHandling$class.finishRecreate($this, cause, failedActor);
    }

    public static void faultSuspend(ActorCell $this) {
        FaultHandling$class.suspendNonRecursive($this);
        $this.suspendChildren($this.suspendChildren$default$1());
    }

    public static void faultResume(ActorCell $this, Throwable causedByFailure) {
        if ($this.actor() == null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Create after ").append(causedByFailure).toString()));
            $this.faultCreate();
        } else if ($this.actor().context() == null && causedByFailure != null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Restart after ").append(causedByFailure).toString()));
            $this.faultRecreate(causedByFailure);
        } else {
            ActorRef perp = FaultHandling$class.perpetrator($this);
            FaultHandling$class.resumeNonRecursive($this);
            $this.resumeChildren(causedByFailure, perp);
        }
        return;
        finally {
            if (causedByFailure != null) {
                FaultHandling$class.clearFailed($this);
            }
        }
    }

    public static void faultCreate(ActorCell $this) {
        Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"mailbox must be suspended during failed creation, status=").append(BoxesRunTime.boxToInteger(this.$outer.mailbox().currentStatus())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        ActorRef actorRef = FaultHandling$class.perpetrator($this);
        InternalActorRef internalActorRef = $this.self();
        Predef$.MODULE$.assert(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null));
        $this.setReceiveTimeout(Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.children().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (!$this.setChildrenTerminationReason(new ChildrenContainer.Creation())) {
            FaultHandling$class.finishCreate($this);
        }
    }

    /*
     * Loose catch block
     */
    private static void finishCreate(ActorCell $this) {
        Throwable throwable2222;
        block6: {
            block5: {
                try {
                    FaultHandling$class.resumeNonRecursive($this);
                    $this.create(None$.MODULE$);
                    break block5;
                }
                finally {
                    FaultHandling$class.clearFailed($this);
                }
                catch (Throwable throwable2222) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr2 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;

                        public final void apply(Throwable e) {
                            this.$outer.handleInvokeFailure(Nil$.MODULE$, e);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    if (!catchExpr2.isDefinedAt(throwable2222)) break block6;
                    catchExpr2.apply(throwable2222);
                }
            }
            return;
        }
        throw throwable2222;
    }

    public static void terminate(ActorCell $this) {
        $this.setReceiveTimeout(Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.unwatchWatchedActors($this.actor());
        $this.children().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if ($this.systemImpl().aborting()) {
            $this.children().foreach(new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorCell $outer;

                public final void apply(ActorRef x0$1) {
                    ActorRef actorRef;
                    ActorRef actorRef2 = x0$1;
                    if (actorRef2 instanceof ActorRefScope && !((ActorRefScope)((Object)(actorRef = actorRef2))).isLocal()) {
                        this.$outer.self().sendSystemMessage(new DeathWatchNotification(actorRef, true, false));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        boolean wasTerminating = $this.isTerminating();
        if ($this.setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                FaultHandling$class.suspendNonRecursive($this);
                FaultHandling$class.setFailed($this, $this.self());
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), "stopping"));
                }
            }
        } else {
            $this.setTerminated();
            FaultHandling$class.akka$actor$dungeon$FaultHandling$$finishTerminate($this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void handleInvokeFailure(ActorCell $this, Iterable childrenNotToSuspend, Throwable t) {
        block6: {
            block7: {
                if (FaultHandling$class.isFailed($this)) break block7;
                try {
                    FaultHandling$class.suspendNonRecursive($this);
                    var6_3 = $this.currentMessage();
                    if (var6_3 == null) ** GOTO lbl-1000
                    var7_4 = var6_3.message();
                    child = var6_3.sender();
                    if (var7_4 instanceof Failed) {
                        FaultHandling$class.setFailed($this, child);
                        var9_6 = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}));
                    } else lbl-1000:
                    // 2 sources

                    {
                        FaultHandling$class.setFailed($this, $this.self());
                        var9_6 = Predef$.MODULE$.Set().empty();
                    }
                    skip = var9_6;
                    $this.suspendChildren((Set)skip.$plus$plus(childrenNotToSuspend));
                    var10_8 = t;
                    if (var10_8 instanceof InterruptedException) {
                        $this.parent().sendSystemMessage(new Failed($this.self(), new ActorInterruptedException(t), $this.uid()));
                        var11_9 = BoxedUnit.UNIT;
                    } else {
                        $this.parent().sendSystemMessage(new Failed($this.self(), t, $this.uid()));
                        var11_10 = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable var3_11) {
                    catchExpr3 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)new Serializable($this, t){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;
                        private final Throwable t$1;

                        public final void apply(Throwable e) {
                            this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), new StringBuilder().append((Object)"emergency stop: exception in failure handling for ").append(this.t$1.getClass()).append((Object)Logging$.MODULE$.stackTraceFor(this.t$1)).toString()));
                            try {
                                this.$outer.children().foreach(new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ FaultHandling$.anonfun.3 $outer;

                                    public final void apply(ActorRef actor) {
                                        this.$outer.akka$actor$dungeon$FaultHandling$$anonfun$$$outer().stop(actor);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                return;
                            }
                            finally {
                                FaultHandling$class.akka$actor$dungeon$FaultHandling$$finishTerminate(this.$outer);
                            }
                        }

                        public /* synthetic */ ActorCell akka$actor$dungeon$FaultHandling$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.t$1 = t$1;
                        }
                    });
                    if (!catchExpr3.isDefinedAt(var3_11)) break block6;
                    catchExpr3.apply(var3_11);
                }
            }
            return;
        }
        throw var3_11;
    }

    /*
     * WARNING - void declaration
     */
    public static void akka$actor$dungeon$FaultHandling$$finishTerminate(ActorCell $this) {
        Throwable throwable22;
        block87: {
            void var1_1;
            Actor a = $this.actor();
            try {
                try {
                    if (a != null) {
                        a.aroundPostStop();
                    }
                }
                catch (Throwable throwable22) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr4 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable($this, a){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;
                        private final Actor a$1;

                        public final void apply(Throwable e) {
                            this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.a$1), e.getMessage()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.a$1 = a$1;
                        }
                    }));
                    if (!catchExpr4.isDefinedAt(throwable22)) break block87;
                    catchExpr4.apply(throwable22);
                }
            }
            catch (Throwable throwable3) {
                try {
                    $this.dispatcher().detach($this);
                }
                finally {
                    try {
                        $this.parent().sendSystemMessage(new DeathWatchNotification($this.self(), true, false));
                    }
                    finally {
                        try {
                            $this.tellWatchersWeDied();
                        }
                        finally {
                            try {
                                $this.unwatchWatchedActors((Actor)var1_1);
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                                }
                                $this.clearActorFields((Actor)var1_1);
                                $this.clearActorCellFields($this);
                                $this.actor_$eq(null);
                            }
                        }
                    }
                }
                throw throwable3;
            }
            try {
                $this.dispatcher().detach($this);
            }
            catch (Throwable throwable4) {
                try {
                    $this.parent().sendSystemMessage(new DeathWatchNotification($this.self(), true, false));
                }
                catch (Throwable throwable5) {
                    try {
                        $this.tellWatchersWeDied();
                    }
                    catch (Throwable throwable6) {
                        try {
                            $this.unwatchWatchedActors((Actor)var1_1);
                            throw throwable6;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                            }
                            $this.clearActorFields((Actor)var1_1);
                            $this.clearActorCellFields($this);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable5;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.clearActorCellFields($this);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.tellWatchersWeDied();
                }
                catch (Throwable throwable7) {
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable7;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.clearActorCellFields($this);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable4;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.clearActorCellFields($this);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.parent().sendSystemMessage(new DeathWatchNotification($this.self(), true, false));
            }
            catch (Throwable throwable8) {
                try {
                    $this.tellWatchersWeDied();
                }
                catch (Throwable throwable9) {
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable9;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.clearActorCellFields($this);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable8;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.clearActorCellFields($this);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied();
            }
            catch (Throwable throwable10) {
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable10;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.clearActorCellFields($this);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.clearActorCellFields($this);
                $this.actor_$eq(null);
                return;
            }
            catch (Throwable throwable11) {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                }
                $this.clearActorFields((Actor)var1_1);
                $this.clearActorCellFields($this);
                $this.actor_$eq(null);
                throw throwable11;
            }
        }
        throw throwable22;
    }

    private static void finishRecreate(ActorCell $this, Throwable cause, Actor failedActor) {
        Throwable throwable22;
        block8: {
            block7: {
                Iterable<ActorRef> survivors = $this.children();
                try {
                    Actor freshActor;
                    block6: {
                        FaultHandling$class.resumeNonRecursive($this);
                        freshActor = $this.newActor();
                        $this.actor_$eq(freshActor);
                        if (freshActor == failedActor) {
                            $this.setActorFields(freshActor, $this, $this.self());
                        }
                        freshActor.aroundPostRestart(cause);
                        if (!$this.system().settings().DebugLifecycle()) break block6;
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(freshActor), "restarted"));
                    }
                    survivors.foreach(new Serializable($this, cause, freshActor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;
                        private final Throwable cause$1;
                        public final Actor freshActor$1;

                        public final void apply(ActorRef child) {
                            Throwable throwable22;
                            block2: {
                                try {
                                    ((InternalActorRef)child).restart(this.cause$1);
                                }
                                catch (Throwable throwable22) {
                                    PartialFunction<Throwable, BoxedUnit> catchExpr5 = this.$outer.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable(this, child){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ FaultHandling$.anonfun.finishRecreate.1 $outer;
                                        private final ActorRef child$1;

                                        public final void apply(Throwable e) {
                                            this.$outer.akka$actor$dungeon$FaultHandling$$anonfun$$$outer().publish(new Logging.Error(e, this.$outer.akka$actor$dungeon$FaultHandling$$anonfun$$$outer().self().path().toString(), this.$outer.akka$actor$dungeon$FaultHandling$$anonfun$$$outer().clazz(this.$outer.freshActor$1), new StringBuilder().append((Object)"restarting ").append(this.child$1).toString()));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.child$1 = child$1;
                                        }
                                    }));
                                    if (!catchExpr5.isDefinedAt(throwable22)) break block2;
                                    catchExpr5.apply(throwable22);
                                }
                                return;
                            }
                            throw throwable22;
                        }

                        public /* synthetic */ ActorCell akka$actor$dungeon$FaultHandling$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cause$1 = cause$1;
                            this.freshActor$1 = freshActor$1;
                        }
                    });
                    break block7;
                    finally {
                        FaultHandling$class.clearFailed($this);
                    }
                }
                catch (Throwable throwable22) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr6 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable($this, cause, survivors){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ActorCell $outer;
                        private final Throwable cause$1;
                        private final Iterable survivors$1;

                        public final void apply(Throwable e) {
                            this.$outer.clearActorFields(this.$outer.actor());
                            this.$outer.handleInvokeFailure(this.survivors$1, new PostRestartException((ActorRef)this.$outer.self(), e, this.cause$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cause$1 = cause$1;
                            this.survivors$1 = survivors$1;
                        }
                    }));
                    if (!catchExpr6.isDefinedAt(throwable22)) break block8;
                    catchExpr6.apply(throwable22);
                }
            }
            return;
        }
        throw throwable22;
    }

    public static final void handleFailure(ActorCell $this, Failed f2) {
        Option<ChildRestartStats> option;
        block6: {
            block4: {
                block5: {
                    Some some;
                    boolean bl;
                    block2: {
                        block3: {
                            $this.currentMessage_$eq(Envelope$.MODULE$.apply(f2, f2.child(), $this.system()));
                            bl = false;
                            some = null;
                            option = $this.getChildByRef(f2.child());
                            if (!(option instanceof Some)) break block2;
                            bl = true;
                            some = (Some)option;
                            ChildRestartStats stats = (ChildRestartStats)some.x();
                            if (stats.uid() != f2.uid()) break block2;
                            if (!$this.actor().supervisorStrategy().handleFailure($this, f2.child(), f2.cause(), stats, $this.getAllChildStats())) break block3;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw f2.cause();
                    }
                    if (!bl) break block5;
                    ChildRestartStats stats = (ChildRestartStats)some.x();
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append(f2.cause()).append((Object)") from old child ").append(f2.child()).append((Object)" (uid=").append(BoxesRunTime.boxToInteger(stats.uid())).append((Object)" != ").append(BoxesRunTime.boxToInteger(f2.uid())).append((Object)")").toString()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append(f2.cause()).append((Object)") from unknown child ").append(f2.child()).toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void handleChildTerminated(ActorCell $this, ActorRef child) {
        ChildrenContainer.SuspendReason suspendReason;
        ChildrenContainer.SuspendReason c;
        BoxedUnit boxedUnit;
        Option<ChildrenContainer.SuspendReason> status = $this.removeChildAndGetStateChange(child);
        if ($this.actor() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                $this.actor().supervisorStrategy().handleChildTerminated($this, child, $this.children());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable2) {
                PartialFunction<Throwable, BoxedUnit> catchExpr7 = $this.handleNonFatalOrInterruptedException((Function1<Throwable, BoxedUnit>)((Object)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;

                    public final void apply(Throwable e) {
                        this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "handleChildTerminated failed"));
                        this.$outer.handleInvokeFailure(Nil$.MODULE$, e);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                if (!catchExpr7.isDefinedAt(throwable2)) throw throwable2;
                boxedUnit = catchExpr7.apply(throwable2);
            }
        }
        boolean bl = false;
        Some some = null;
        Option<ChildrenContainer.SuspendReason> option = status;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ChildrenContainer.SuspendReason c2 = (ChildrenContainer.SuspendReason)some.x();
            if (c2 instanceof ChildrenContainer.Recreation) {
                ChildrenContainer.Recreation recreation = (ChildrenContainer.Recreation)c2;
                Throwable cause = recreation.cause();
                FaultHandling$class.finishRecreate($this, cause, $this.actor());
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (c = (ChildrenContainer.SuspendReason)some.x()) instanceof ChildrenContainer.Creation) {
            FaultHandling$class.finishCreate($this);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        if (bl && ChildrenContainer$Termination$.MODULE$.equals(suspendReason = (ChildrenContainer.SuspendReason)some.x())) {
            FaultHandling$class.akka$actor$dungeon$FaultHandling$$finishTerminate($this);
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
    }

    public static final PartialFunction handleNonFatalOrInterruptedException(ActorCell $this, Function1 thunk) {
        return new Serializable($this, thunk){
            public static final long serialVersionUID = 0L;
            private final Function1 thunk$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    this.thunk$1.apply(interruptedException);
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(A1);
                    if (option.isEmpty()) {
                        object = function1.apply(x1);
                    } else {
                        Throwable e = option.get();
                        object = this.thunk$1.apply(e);
                    }
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option<Throwable> option;
                Throwable throwable2 = x1;
                boolean bl = throwable2 instanceof InterruptedException ? true : !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty();
                return bl;
            }
            {
                this.thunk$1 = thunk$1;
            }
        };
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }
}

