/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInitializationException;
import akka.actor.ActorInitializationException$;
import akka.actor.DeadLetter;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.dungeon.AbstractActorCell;
import akka.dispatch.Envelope;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Terminate;
import akka.event.Logging;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.Unsafe;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell init(ActorCell $this, boolean sendSupervise, MailboxType mailboxType) {
        Create create2;
        Mailbox mbox = $this.dispatcher().createMailbox($this, mailboxType);
        Class<? extends Actor> actorClass = $this.props().actorClass();
        MailboxType mailboxType2 = mailboxType;
        if (mailboxType2 instanceof ProducesMessageQueue && $this.system().mailboxes().hasRequiredType(actorClass)) {
            Create create3;
            Class<?> req = $this.system().mailboxes().getRequiredType(actorClass);
            if (req.isInstance(mbox.messageQueue())) {
                create3 = new Create(None$.MODULE$);
            } else {
                String gotType = mbox.messageQueue() == null ? "null" : mbox.messageQueue().getClass().getName();
                create3 = new Create(new Some<ActorInitializationException>(ActorInitializationException$.MODULE$.apply($this.self(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actor [", "] requires mailbox type [", "] got [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.self(), req, gotType})), ActorInitializationException$.MODULE$.apply$default$3())));
            }
            create2 = create3;
        } else {
            create2 = new Create(None$.MODULE$);
        }
        Create createMessage = create2;
        $this.swapMailbox(mbox);
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), createMessage);
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self(), false));
        }
        return $this;
    }

    public static ActorCell start(ActorCell $this) {
        $this.dispatcher().attach($this);
        return $this;
    }

    private static PartialFunction handleException(ActorCell $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    this.$outer.system().eventStream().publish(new Logging.Error(interruptedException, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "interrupted during message send"));
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(A1);
                    if (option.isEmpty()) {
                        object = function1.apply(x1);
                    } else {
                        Throwable e = option.get();
                        this.$outer.system().eventStream().publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "swallowing exception during message send"));
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option<Throwable> option;
                Throwable throwable2 = x1;
                boolean bl = throwable2 instanceof InterruptedException ? true : !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final void suspend(ActorCell $this) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Suspend());
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr1 = Dispatch$class.handleException($this);
                if (!catchExpr1.isDefinedAt(throwable22)) break block2;
                catchExpr1.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void resume(ActorCell $this, Throwable causedByFailure) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Resume(causedByFailure));
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr2 = Dispatch$class.handleException($this);
                if (!catchExpr2.isDefinedAt(throwable22)) break block2;
                catchExpr2.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Recreate(cause));
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr3 = Dispatch$class.handleException($this);
                if (!catchExpr3.isDefinedAt(throwable22)) break block2;
                catchExpr3.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static final void stop(ActorCell $this) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Terminate());
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr4 = Dispatch$class.handleException($this);
                if (!catchExpr4.isDefinedAt(throwable22)) break block2;
                catchExpr4.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static void sendMessage(ActorCell $this, Envelope msg) {
        Throwable throwable22;
        block8: {
            try {
                BoxedUnit boxedUnit;
                if ($this.system().settings().SerializeAllMessages()) {
                    Object object;
                    Object object2 = msg.message();
                    if (object2 instanceof DeadLetter) {
                        Object wrapped;
                        DeadLetter deadLetter = (DeadLetter)object2;
                        object = wrapped = deadLetter.message();
                    } else {
                        object = object2;
                    }
                    Object unwrapped = object;
                    if (unwrapped instanceof NoSerializationVerificationNeeded) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Serialization s2 = (Serialization)SerializationExtension$.MODULE$.apply($this.system());
                        boxedUnit = s2.deserialize(s2.serialize(unwrapped).get(), unwrapped.getClass()).get();
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.dispatcher().dispatch($this, msg);
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr5 = Dispatch$class.handleException($this);
                if (!catchExpr5.isDefinedAt(throwable22)) break block8;
                catchExpr5.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        Throwable throwable22;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, message);
            }
            catch (Throwable throwable22) {
                PartialFunction catchExpr6 = Dispatch$class.handleException($this);
                if (!catchExpr6.isDefinedAt(throwable22)) break block2;
                catchExpr6.apply(throwable22);
            }
            return;
        }
        throw throwable22;
    }

    public static void $init$(ActorCell $this) {
    }
}

