/*
 * Decompiled with CFR 0.152.
 */
package deepwater.datasets;

import deepwater.datasets.ImageBatch;
import deepwater.datasets.ImageDataSet;
import deepwater.datasets.Pair;
import java.io.IOException;
import java.util.List;

public class BatchIterator {
    private final ImageDataSet data;
    private final int totalEpochs;
    private int currentEpoch;
    private List<Pair<Integer, float[]>> imageLabelList;
    private int savedIterator;
    private String[] images;

    public BatchIterator(ImageDataSet data, int epochs, String ... images) {
        this.data = data;
        this.totalEpochs = epochs;
        this.currentEpoch = 0;
        this.images = new String[0];
        this.images = images;
    }

    public void newEpoch() throws IOException {
        ++this.currentEpoch;
        this.imageLabelList = this.data.loadImages(this.images);
    }

    public boolean next(ImageBatch b) throws IOException {
        if (this.savedIterator == 0) {
            this.newEpoch();
        }
        if (this.currentEpoch > this.totalEpochs) {
            return false;
        }
        b.reset();
        for (int ii = this.savedIterator; ii < this.imageLabelList.size(); ++ii) {
            int i = ii % b.size;
            Pair<Integer, float[]> entry = this.imageLabelList.get(i);
            float[] image = entry.getSecond();
            Integer label = entry.getFirst();
            System.arraycopy(image, 0, b.images, i * image.length, image.length);
            b.labels[i * this.data.getNumClasses() + label.intValue()] = 1.0f;
            ++this.savedIterator;
            if (++i != b.size) continue;
            return true;
        }
        this.savedIterator = 0;
        return false;
    }

    public boolean nextEpochs() {
        return this.currentEpoch <= this.totalEpochs;
    }
}

