/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.8
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <string>


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include "image_train.hpp"


#include "image_pred.hpp"


#include "include/c_api.h"


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  bool arg6 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = jarg6 ? true : false; 
  result = (ImageTrain *)new ImageTrain(arg1,arg2,arg3,arg4,arg5,arg6);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (ImageTrain *)new ImageTrain(arg1,arg2,arg3,arg4,arg5);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (ImageTrain *)new ImageTrain(arg1,arg2,arg3,arg4);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (ImageTrain *)new ImageTrain(arg1,arg2,arg3);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (ImageTrain *)new ImageTrain(arg1,arg2);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ImageTrain *)new ImageTrain(arg1);
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImageTrain_1_1SWIG_16(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ImageTrain *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ImageTrain *)new ImageTrain();
  *(ImageTrain **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4, jint jarg5, jintArray jarg6, jobjectArray jarg7, jdouble jarg8, jdoubleArray jarg9) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  double arg8 ;
  double *arg9 = (double *) 0 ;
  jint *jarr6 ;
  jint size7 ;
  jdouble *jarr9 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr6, (int **)&arg6, jarg6)) return ; 
  {
    int i = 0;
    if (jarg7) {
      size7 = jenv->GetArrayLength(jarg7);
      
      arg7 = new char*[size7+1];
      
      
      
      for (i = 0; i<size7; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg7, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg7[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg7[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg7[i] = 0;
    } else {
      arg7 = 0;
      size7 = 0;
    }
  }
  arg8 = (double)jarg8; 
  if (!SWIG_JavaArrayInDouble(jenv, &jarr9, (double **)&arg9, jarg9)) return ; 
  (arg1)->buildNet(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  SWIG_JavaArrayArgoutInt(jenv, jarr6, (int *)arg6, jarg6); 
  SWIG_JavaArrayArgoutDouble(jenv, jarr9, (double *)arg9, jarg9); 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  delete [] arg6; 
  {
    int i;
    for (i=0; i<size7; i++)
    
    delete[] arg7[i];
    delete[] arg7;
    
    
    
    
  }
  delete [] arg9; 
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4, jint jarg5, jintArray jarg6, jobjectArray jarg7, jdouble jarg8) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  double arg8 ;
  jint *jarr6 ;
  jint size7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr6, (int **)&arg6, jarg6)) return ; 
  {
    int i = 0;
    if (jarg7) {
      size7 = jenv->GetArrayLength(jarg7);
      
      arg7 = new char*[size7+1];
      
      
      
      for (i = 0; i<size7; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg7, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg7[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg7[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg7[i] = 0;
    } else {
      arg7 = 0;
      size7 = 0;
    }
  }
  arg8 = (double)jarg8; 
  (arg1)->buildNet(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  SWIG_JavaArrayArgoutInt(jenv, jarr6, (int *)arg6, jarg6); 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  delete [] arg6; 
  {
    int i;
    for (i=0; i<size7; i++)
    
    delete[] arg7[i];
    delete[] arg7;
    
    
    
    
  }
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4, jint jarg5, jintArray jarg6, jobjectArray jarg7) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  char **arg7 = (char **) 0 ;
  jint *jarr6 ;
  jint size7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr6, (int **)&arg6, jarg6)) return ; 
  {
    int i = 0;
    if (jarg7) {
      size7 = jenv->GetArrayLength(jarg7);
      
      arg7 = new char*[size7+1];
      
      
      
      for (i = 0; i<size7; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg7, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg7[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg7[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg7[i] = 0;
    } else {
      arg7 = 0;
      size7 = 0;
    }
  }
  (arg1)->buildNet(arg2,arg3,arg4,arg5,arg6,arg7);
  SWIG_JavaArrayArgoutInt(jenv, jarr6, (int *)arg6, jarg6); 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  delete [] arg6; 
  {
    int i;
    for (i=0; i<size7; i++)
    
    delete[] arg7[i];
    delete[] arg7;
    
    
    
    
  }
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4, jint jarg5, jintArray jarg6) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  int arg5 ;
  int *arg6 = (int *) 0 ;
  jint *jarr6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr6, (int **)&arg6, jarg6)) return ; 
  (arg1)->buildNet(arg2,arg3,arg4,arg5,arg6);
  SWIG_JavaArrayArgoutInt(jenv, jarr6, (int *)arg6, jarg6); 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  delete [] arg6; 
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4, jint jarg5) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  (arg1)->buildNet(arg2,arg3,arg4,arg5);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1buildNet_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jstring jarg4) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  (arg1)->buildNet(arg2,arg3,arg4);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1setSeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setSeed(arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1loadModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->loadModel(arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1saveModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->saveModel(arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1loadParam(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->loadParam(arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1saveParam(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->saveParam(arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1toJson(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  result = (char *)(arg1)->toJson();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jfloatArray JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1loadMeanImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jfloatArray jresult = 0 ;
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  char *arg2 = (char *) 0 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->loadMeanImage((char const *)arg2);
  {
    const jsize sz = (&result)->size();
    jresult = jenv->NewFloatArray(sz);
    jfloat* const jarr = jenv->GetFloatArrayElements(jresult, 0);
    if (!jarr) return 0;
    for ( jsize i = 0; i < sz; i++ )
    jarr[i] = result[i];
    jenv->ReleaseFloatArrayElements(jresult, jarr, 0);
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1setLR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->setLR(arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1setWD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->setWD(arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1setMomentum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->setMomentum(arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1setClipGradient(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->setClipGradient(arg2);
}


SWIGEXPORT jfloatArray JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1train(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2, jfloatArray jarg3) {
  jfloatArray jresult = 0 ;
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float *arg2 = (float *) 0 ;
  float *arg3 = (float *) 0 ;
  jfloat *jarr2 ;
  jfloat *jarr3 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return 0; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr3, (float **)&arg3, jarg3)) return 0; 
  result = (arg1)->train(arg2,arg3);
  {
    const jsize sz = (&result)->size();
    jresult = jenv->NewFloatArray(sz);
    jfloat* const jarr = jenv->GetFloatArrayElements(jresult, 0);
    if (!jarr) return 0;
    for ( jsize i = 0; i < sz; i++ )
    jarr[i] = result[i];
    jenv->ReleaseFloatArrayElements(jresult, jarr, 0);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  SWIG_JavaArrayArgoutFloat(jenv, jarr3, (float *)arg3, jarg3); 
  delete [] arg2; 
  delete [] arg3; 
  return jresult;
}


SWIGEXPORT jfloatArray JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1predict_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2, jfloatArray jarg3) {
  jfloatArray jresult = 0 ;
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float *arg2 = (float *) 0 ;
  float *arg3 = (float *) 0 ;
  jfloat *jarr2 ;
  jfloat *jarr3 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return 0; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr3, (float **)&arg3, jarg3)) return 0; 
  result = (arg1)->predict(arg2,arg3);
  {
    const jsize sz = (&result)->size();
    jresult = jenv->NewFloatArray(sz);
    jfloat* const jarr = jenv->GetFloatArrayElements(jresult, 0);
    if (!jarr) return 0;
    for ( jsize i = 0; i < sz; i++ )
    jarr[i] = result[i];
    jenv->ReleaseFloatArrayElements(jresult, jarr, 0);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  SWIG_JavaArrayArgoutFloat(jenv, jarr3, (float *)arg3, jarg3); 
  delete [] arg2; 
  delete [] arg3; 
  return jresult;
}


SWIGEXPORT jfloatArray JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImageTrain_1predict_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  jfloatArray jresult = 0 ;
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  float *arg2 = (float *) 0 ;
  jfloat *jarr2 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImageTrain **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return 0; 
  result = (arg1)->predict(arg2);
  {
    const jsize sz = (&result)->size();
    jresult = jenv->NewFloatArray(sz);
    jfloat* const jarr = jenv->GetFloatArrayElements(jresult, 0);
    if (!jarr) return 0;
    for ( jsize i = 0; i < sz; i++ )
    jarr[i] = result[i];
    jenv->ReleaseFloatArrayElements(jresult, jarr, 0);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_delete_1ImageTrain(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ImageTrain *arg1 = (ImageTrain *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ImageTrain **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImagePred_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  ImagePred *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (ImagePred *)new ImagePred(arg1,arg2,arg3);
  *(ImagePred **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImagePred_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  ImagePred *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (ImagePred *)new ImagePred(arg1,arg2);
  *(ImagePred **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImagePred_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ImagePred *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ImagePred *)new ImagePred(arg1);
  *(ImagePred **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_new_1ImagePred_1_1SWIG_13(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ImagePred *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ImagePred *)new ImagePred();
  *(ImagePred **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_delete_1ImagePred(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ImagePred *arg1 = (ImagePred *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ImagePred **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1setSeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ImagePred *arg1 = (ImagePred *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setSeed(arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1setModelPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ImagePred *arg1 = (ImagePred *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->setModelPath(arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1loadInception(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  ImagePred *arg1 = (ImagePred *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  (arg1)->loadInception();
}


SWIGEXPORT void JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1loadModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  ImagePred *arg1 = (ImagePred *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  (arg1)->loadModel();
}


SWIGEXPORT jstring JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1predict(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  jstring jresult = 0 ;
  ImagePred *arg1 = (ImagePred *) 0 ;
  float *arg2 = (float *) 0 ;
  jfloat *jarr2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return 0; 
  result = (arg1)->predict(arg2);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT jfloatArray JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_ImagePred_1predict_1probs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloatArray jarg2) {
  jfloatArray jresult = 0 ;
  ImagePred *arg1 = (ImagePred *) 0 ;
  float *arg2 = (float *) 0 ;
  jfloat *jarr2 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ImagePred **)&jarg1; 
  if (!SWIG_JavaArrayInFloat(jenv, &jarr2, (float **)&arg2, jarg2)) return 0; 
  result = (arg1)->predict_probs(arg2);
  {
    const jsize sz = (&result)->size();
    jresult = jenv->NewFloatArray(sz);
    jfloat* const jarr = jenv->GetFloatArrayElements(jresult, 0);
    if (!jarr) return 0;
    for ( jsize i = 0; i < sz; i++ )
    jarr[i] = result[i];
    jenv->ReleaseFloatArrayElements(jresult, jarr, 0);
  }
  SWIG_JavaArrayArgoutFloat(jenv, jarr2, (float *)arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_deepwater_backends_mxnet_deepwaterJNI_MXNotifyShutdown(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)MXNotifyShutdown();
  jresult = (jint)result; 
  return jresult;
}


#ifdef __cplusplus
}
#endif

