% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{plot.H2OTabulate}
\alias{plot.H2OTabulate}
\title{Plot an H2O Tabulate Heatmap}
\usage{
\method{plot}{H2OTabulate}(x, xlab = x$cols[1], ylab = x$cols[2],
  base_size = 12, ...)
}
\arguments{
\item{x}{An H2OTabulate object for which the heatmap plot is desired.}

\item{xlab}{A title for the x-axis.  Defaults to what is specified in the given H2OTabulate object.}

\item{ylab}{A title for the y-axis.  Defaults to what is specified in the given H2OTabulate object.}

\item{base_size}{Base font size for plot.}

\item{...}{additional arguments to pass on.}
}
\value{
Returns a ggplot2-based heatmap of co-occurance.
}
\description{
Plots the simple co-occurrence based tabulation of X vs Y as a heatmap, where X and Y are two Vecs in a given dataset. This function requires suggested ggplot2 package.
}
\examples{
\donttest{
library(h2o)
h2o.init()
df <- as.h2o(iris)
tab <- h2o.tabulate(data = df, x = "Sepal.Length", y = "Petal.Width",
             weights_column = NULL, nbins_x = 10, nbins_y = 10)
plot(tab)              
}
}
\seealso{
\code{link{h2o.tabulate}}
}

