% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.rmsle}
\alias{h2o.rmsle}
\title{Retrieve the Root Mean Squared Log Error}
\usage{
h2o.rmsle(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{train}{Retrieve the training rmsle}

\item{valid}{Retrieve the validation set rmsle if a validation set was passed in during model build time.}

\item{xval}{Retrieve the cross-validation rmsle}
}
\description{
Retrieves the root mean squared log error (RMSLE) value from an H2O model.
If "train", "valid", and "xval" parameters are FALSE (default), then the training rmsle value is returned. If more
than one parameter is set to TRUE, then a named vector of rmsles are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\donttest{
library(h2o)

h <- h2o.init()
fr <- as.h2o(iris)

m <- h2o.deeplearning(x=2:5,y=1,training_frame=fr)

h2o.rmsle(m)
}
}

