% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.removeAll}
\alias{h2o.removeAll}
\title{Remove All Objects on the H2O Cluster}
\usage{
h2o.removeAll(timeout_secs = 0)
}
\arguments{
\item{timeout_secs}{Timeout in seconds. Default is no timeout.}
}
\description{
Removes the data from the h2o cluster, but does not remove the local references.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
h2o.ls()
h2o.removeAll()
h2o.ls()
}
}
\seealso{
\code{\link{h2o.rm}}
}

