% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.quantile}
\alias{h2o.quantile}
\alias{quantile.H2OFrame}
\title{Quantiles of H2O Frames.}
\usage{
h2o.quantile(x, probs = c(0.001, 0.01, 0.1, 0.25, 0.333, 0.5, 0.667, 0.75,
  0.9, 0.99, 0.999), combine_method = c("interpolate", "average", "avg",
  "low", "high"), weights_column = NULL, ...)

\method{quantile}{H2OFrame}(x, probs = c(0.001, 0.01, 0.1, 0.25, 0.333, 0.5,
  0.667, 0.75, 0.9, 0.99, 0.999), combine_method = c("interpolate", "average",
  "avg", "low", "high"), weights_column = NULL, ...)
}
\arguments{
\item{x}{An \code{H2OFrame} object with a single numeric column.}

\item{probs}{Numeric vector of probabilities with values in [0,1].}

\item{combine_method}{How to combine quantiles for even sample sizes. Default is to do linear interpolation.
E.g., If method is "lo", then it will take the lo value of the quantile. Abbreviations for average, low, and high are acceptable (avg, lo, hi).}

\item{weights_column}{(Optional) String name of the observation weights column in x or an \code{H2OFrame} object with a single numeric column of observation weights.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector describing the percentiles at the given cutoffs for the \code{H2OFrame} object.
}
\description{
Obtain and display quantiles for H2O parsed data.
}
\details{
\code{quantile.H2OFrame}, a method for the \code{\link{quantile}} generic. Obtain and return quantiles for
an \code{H2OFrame} object.
}
\examples{
\donttest{
# Request quantiles for an H2O parsed data set:
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
# Request quantiles for a subset of columns in an H2O parsed data set
quantile(prostate.hex[,3])
for(i in 1:ncol(prostate.hex))
   quantile(prostate.hex[,i])
}
}

