% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{h2o.grid}
\alias{h2o.grid}
\title{H2O Grid Support}
\usage{
h2o.grid(algorithm, grid_id, ..., hyper_params = list(),
  is_supervised = NULL, do_hyper_params_check = FALSE,
  search_criteria = NULL)
}
\arguments{
\item{algorithm}{Name of algorithm to use in grid search (gbm, randomForest, kmeans, glm, deeplearning, naivebayes, pca).}

\item{grid_id}{(Optional) ID for resulting grid search. If it is not specified then it is autogenerated.}

\item{...}{arguments describing parameters to use with algorithm (i.e., x, y, training_frame).
Look at the specific algorithm - h2o.gbm, h2o.glm, h2o.kmeans, h2o.deepLearning - for available parameters.}

\item{hyper_params}{List of lists of hyper parameters (i.e., \code{list(ntrees=c(1,2), max_depth=c(5,7))}).}

\item{is_supervised}{(Optional) If specified then override the default heuristic which decides if the given algorithm
name and parameters specify a supervised or unsupervised algorithm.}

\item{do_hyper_params_check}{Perform client check for specified hyper parameters. It can be time expensive for
large hyper space.}

\item{search_criteria}{(Optional)  List of control parameters for smarter hyperparameter search.  The default
strategy 'Cartesian' covers the entire space of hyperparameter combinations.  Specify the
'RandomDiscrete' strategy to get random search of all the combinations of your hyperparameters.  RandomDiscrete
should be usually combined with at least one early stopping criterion,
max_models and/or max_runtime_secs, e.g. \code{list(strategy = "RandomDiscrete", max_models = 42, max_runtime_secs = 28800)}
or  \code{list(strategy = "RandomDiscrete", stopping_metric = "AUTO", stopping_tolerance = 0.001, stopping_rounds = 10)}
or  \code{list(strategy = "RandomDiscrete", stopping_metric = "misclassification", stopping_tolerance = 0.00001, stopping_rounds = 5)}.}
}
\description{
Provides a set of functions to launch a grid search and get
its results.
}
\details{
Launch grid search with given algorithm and parameters.
}
\examples{
\donttest{
library(h2o)
library(jsonlite)
h2o.init()
iris.hex <- as.h2o(iris)
grid <- h2o.grid("gbm", x = c(1:4), y = 5, training_frame = iris.hex,
                 hyper_params = list(ntrees = c(1,2,3)))
# Get grid summary
summary(grid)
# Fetch grid models
model_ids <- grid@model_ids
models <- lapply(model_ids, function(id) { h2o.getModel(id)})
}
}

