% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.describe}
\alias{h2o.describe}
\title{H2O Description of A Dataset}
\usage{
h2o.describe(frame)
}
\arguments{
\item{frame}{An H2OFrame object.}
}
\value{
A table with the Frame stats.
}
\description{
Reports the "Flow" style summary rollups on an instance of H2OFrame. Includes
information about column types, mins/maxs/missing/zero counts/stds/number of levels
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath = system.file("extdata", "prostate.csv", package="h2o")
prostate.hex = h2o.importFile(path = prosPath)
h2o.describe(prostate.hex)
}
}

