% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deeplearning.R
\name{h2o.deepfeatures}
\alias{h2o.deepfeatures}
\title{Feature Generation via H2O Deep Learning Model}
\usage{
h2o.deepfeatures(object, data, layer = 1)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object that represents the deep
learning model to be used for feature extraction.}

\item{data}{An H2OFrame object.}

\item{layer}{Index of the hidden layer to extract.}
}
\value{
Returns an H2OFrame object with as many features as the
        number of units in the hidden layer of the specified index.
}
\description{
Extract the non-linear feature from an H2O data set using an H2O deep learning
model.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.importFile(path = prosPath)
prostate.dl = h2o.deeplearning(x = 3:9, y = 2, training_frame = prostate.hex,
                               hidden = c(100, 200), epochs = 5)
prostate.deepfeatures_layer1 = h2o.deepfeatures(prostate.dl, prostate.hex, layer = 1)
prostate.deepfeatures_layer2 = h2o.deepfeatures(prostate.dl, prostate.hex, layer = 2)
head(prostate.deepfeatures_layer1)
head(prostate.deepfeatures_layer2)
}
}
\seealso{
\code{link{h2o.deeplearning}} for making deep learning models.
}

