/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public class ParseUtils {
    public static double[] parseArrayOfDoubles(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        double[] res = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Double.parseDouble(parts[i].trim());
        }
        return res;
    }

    public static int[] parseArrayOfInts(String input) {
        if (!input.startsWith("[") || !input.endsWith("]")) {
            throw new NumberFormatException("Array should be enclosed in square brackets");
        }
        String[] parts = input.substring(1, input.length() - 1).split(",");
        int[] res = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            res[i] = Integer.parseInt(parts[i].trim());
        }
        return res;
    }

    public static Object tryParse(String input) {
        if (input.equals("true")) {
            return true;
        }
        if (input.equals("false")) {
            return false;
        }
        if (input.equals("null")) {
            return null;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return ParseUtils.parseArrayOfInts(input);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return ParseUtils.parseArrayOfDoubles(input);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return input;
                    }
                }
            }
        }
    }
}

