/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import hex.genmodel.utils.ByteBufferWrapper;

public class GenmodelBitSet {
    private byte[] _val;
    private int _byteoff;
    private int _nbits;
    private int _bitoff;

    public GenmodelBitSet(int nbits) {
        this(nbits, 0);
    }

    public GenmodelBitSet(int nbits, int bitoff) {
        if (bitoff + nbits <= 32) {
            bitoff = 0;
            nbits = 32;
        }
        this.fill(nbits <= 0 ? null : new byte[GenmodelBitSet.bytes(nbits)], 0, nbits, bitoff);
    }

    public void fill(byte[] v, int byteoff, int nbits, int bitoff) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (byteoff < 0) {
            throw new IndexOutOfBoundsException("byteoff < 0: " + byteoff);
        }
        if (bitoff < 0) {
            throw new IndexOutOfBoundsException("bitoff < 0: " + bitoff);
        }
        assert (v == null || byteoff + (nbits - 1 >> 3) + 1 <= v.length);
        this._val = v;
        this._nbits = nbits;
        this._bitoff = bitoff;
        this._byteoff = byteoff;
    }

    public boolean contains(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx < 0: " + idx);
        }
        return (idx -= this._bitoff) >= 0 && idx < this._nbits && (this._val[this._byteoff + (idx >> 3)] & 1 << (idx & 7)) != 0;
    }

    public void fill2(byte[] bits, ByteBufferWrapper ab) {
        this.fill(bits, ab.position(), 32, 0);
        ab.skip(4);
    }

    public void fill3(byte[] bits, ByteBufferWrapper ab) {
        char bitoff = ab.get2();
        char nbytes = ab.get2();
        this.fill(bits, ab.position(), nbytes << 3, bitoff);
        ab.skip(nbytes);
    }

    private static int bytes(int nbits) {
        return (nbits - 1 >> 3) + 1;
    }
}

