/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

public enum DistributionFamily {
    AUTO,
    bernoulli{

        @Override
        public double link(double f) {
            return 1.log(f / (1.0 - f));
        }

        @Override
        public double linkInv(double f) {
            return 1.0 / (1.0 + 1.exp(-f));
        }

        @Override
        public String linkInvString(String f) {
            return "1./(1. + " + 1.expString("-(" + f + ")") + ")";
        }
    }
    ,
    modified_huber{

        @Override
        public double link(double f) {
            return 2.log(f / (1.0 - f));
        }

        @Override
        public double linkInv(double f) {
            return 1.0 / (1.0 + 2.exp(-f));
        }

        @Override
        public String linkInvString(String f) {
            return "1./(1. + " + 2.expString("-(" + f + ")") + ")";
        }
    }
    ,
    multinomial{

        @Override
        public double link(double f) {
            return 3.log(f);
        }

        @Override
        public double linkInv(double f) {
            return 3.exp(f);
        }

        @Override
        public String linkInvString(String f) {
            return 3.expString(f);
        }
    }
    ,
    gaussian{}
    ,
    poisson{

        @Override
        public double link(double f) {
            return 5.log(f);
        }

        @Override
        public double linkInv(double f) {
            return 5.exp(f);
        }

        @Override
        public String linkInvString(String f) {
            return 5.expString(f);
        }
    }
    ,
    gamma{

        @Override
        public double link(double f) {
            return 6.log(f);
        }

        @Override
        public double linkInv(double f) {
            return 6.exp(f);
        }

        @Override
        public String linkInvString(String f) {
            return 6.expString(f);
        }
    }
    ,
    tweedie{

        @Override
        public double link(double f) {
            return 7.log(f);
        }

        @Override
        public double linkInv(double f) {
            return 7.exp(f);
        }

        @Override
        public String linkInvString(String f) {
            return 7.expString(f);
        }
    }
    ,
    huber,
    laplace,
    quantile;


    public double linkInv(double f) {
        return f;
    }

    public double link(double f) {
        return f;
    }

    public String linkInvString(String f) {
        return f;
    }

    public static double exp(double x) {
        return Math.min(1.0E19, Math.exp(x));
    }

    public static String expString(String x) {
        return "Math.min(1e19, Math.exp(" + x + "))";
    }

    public static double log(double x) {
        return x <= 0.0 ? -19.0 : Math.max(-19.0, Math.log(x));
    }
}

